//
//  MCTouchServer.h
//  MCClientServer
//
//  Created by Brent Gulanowski on 10-02-08.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//


#import <MCNetComm/MCFileTransferEndpoint.h>

#import <MCClientServer/MCClientServerDefines.h>

#import "MCTouchSyncGlobals.h"


#define FIOChannel (MCFileIOChannel *)[self channel]


@class MCSyncHost, MCTouchChangeManager, MCClientStage, MCAccessClient, MCSQLiteContext, MCServerKeychain, MCPGDatabase;

@interface MCTouchdEndpoint : MCFileTransferEndpoint {
	
	MCSyncHost *syncHost;
	MCClientStage *stage;

	NSString *serverDatabaseUUID;
	
	// login arguments
	NSString *clientDatabaseUUID;
	NSString *clientUUID;
    NSInteger clientReplicationOffset;
	NSString *deviceName;
	NSString *deviceModel;
	
	MCSReplicaStatus clientStatus;
	NSString *userDisplayName;
	
    NSDate* expiryDate;
    MCSLicenseType  licenseType;

	unsigned syncProtocolMinorVersion;
	BOOL initSucceeded;
	BOOL syncSucceeded;
	BOOL stagedRunning;

	double stageInitIncrement;
	double stageInitProgress;
	double progressOverdueAmount;
    
    NSNumber *maxChangeLogIDRetrieved;

    
}

@property (nonatomic, retain) MCSyncHost *syncHost;
@property (nonatomic, retain) MCClientStage *stage;

@property (nonatomic, copy) NSString *serverDatabaseUUID;
@property (nonatomic, copy) NSString *clientDatabaseUUID;
@property (nonatomic, assign) NSInteger clientReplicationOffset;
@property (nonatomic, copy) NSString *clientUUID;
@property (nonatomic, copy) NSString *deviceName;
@property (nonatomic, copy) NSString *deviceModel;
@property (nonatomic, copy) NSDate* expiryDate;
@property (nonatomic, copy) NSString *userDisplayName;

@property (nonatomic) MCSLicenseType licenseType;

@property (nonatomic) double stageInitIncrement;
@property (nonatomic) double stageInitProgress;
@property (nonatomic) double progressOverdueAmount;
@property (nonatomic, readonly) BOOL shouldCompressUploads;

// used by direct sync subclass
@property (nonatomic, retain) NSNumber *maxChangeLogIDRetrieved;


- (MCLoginResult)verifyLicensingForReplicant: (NSDictionary*)replicant;

- (BOOL)updateReplicantWithClientUUID:(NSString *)oldUUID
                            toNewUUID:(NSString *)newUUID
                        usingDatabase:(MCPGDatabase *)dc;

// connects to the stage DB if it is there or creates if it does not exist
- (BOOL)connectToStageDatabase;

// subclass convenience
- (void)sendLoginResponseDidAuthorize:(MCLoginResult)okProceed
                  additionalArguments:(NSDictionary *)additionalArgs;
- (void)handle_login_request:(NSDictionary *)aDictionary;
- (void)handle_sync_down:(NSDictionary *)aDictionary;
- (BOOL)shouldRunStagedAfterChannelDidClose;
- (void)cleanupAfterSyncSucceeded; // call super if you override
- (void)didSuccessfullyUploadStageDBAtPath:(NSString *)path;



// subclass responsibility
- (BOOL)renameTouchFolderFrom:(NSString *)originalUUID to:(NSString *)newUUID error:(NSError **)error;

@end
